#region Using declarations
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.ComponentModel.DataAnnotations;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Input;
using System.Windows.Media;
using System.Xml.Serialization;
using NinjaTrader.Cbi;
using NinjaTrader.Gui;
using NinjaTrader.Gui.Chart;
using NinjaTrader.Gui.SuperDom;
using NinjaTrader.Gui.Tools;
using NinjaTrader.Data;
using NinjaTrader.NinjaScript;
using NinjaTrader.Core.FloatingPoint;

#endregion



#region NinjaScript generated code. Neither change nor remove.

namespace NinjaTrader.NinjaScript.Indicators
{
	public partial class Indicator : NinjaTrader.Gui.NinjaScript.IndicatorRenderBase
	{
		
		private OrderFlowsTrader[] cacheOrderFlowsTrader;

		
		public OrderFlowsTrader OrderFlowsTrader()
		{
			return OrderFlowsTrader(Input);
		}


		
		public OrderFlowsTrader OrderFlowsTrader(ISeries<double> input)
		{
			if (cacheOrderFlowsTrader != null)
				for (int idx = 0; idx < cacheOrderFlowsTrader.Length; idx++)
					if ( cacheOrderFlowsTrader[idx].EqualsInput(input))
						return cacheOrderFlowsTrader[idx];
			return CacheIndicator<OrderFlowsTrader>(new OrderFlowsTrader(), input, ref cacheOrderFlowsTrader);
		}

	}
}

namespace NinjaTrader.NinjaScript.MarketAnalyzerColumns
{
	public partial class MarketAnalyzerColumn : MarketAnalyzerColumnBase
	{
		
		public Indicators.OrderFlowsTrader OrderFlowsTrader()
		{
			return indicator.OrderFlowsTrader(Input);
		}


		
		public Indicators.OrderFlowsTrader OrderFlowsTrader(ISeries<double> input )
		{
			return indicator.OrderFlowsTrader(input);
		}
	
	}
}

namespace NinjaTrader.NinjaScript.Strategies
{
	public partial class Strategy : NinjaTrader.Gui.NinjaScript.StrategyRenderBase
	{
		
		public Indicators.OrderFlowsTrader OrderFlowsTrader()
		{
			return indicator.OrderFlowsTrader(Input);
		}


		
		public Indicators.OrderFlowsTrader OrderFlowsTrader(ISeries<double> input )
		{
			return indicator.OrderFlowsTrader(input);
		}

	}
}

#endregion
